#ifndef _HTML_BUTTON_H_
#define _HTML_BUTTON_H_

#include <wx/html/htmlwin.h>

class HTMLButton: public wxHtmlWindow
{
private:
    int m_clickState;
    bool m_disabled;
    wxStringToStringHashMap m_styles;
    wxString m_html;
    wxString m_style;
    void updateHtml();
    void handleMouseEvent(wxMouseEvent& event);

public:
    HTMLButton();
    HTMLButton(wxWindow *parent, wxWindowID id = wxID_ANY,
                 const wxPoint& pos = wxDefaultPosition,
                 const wxSize& size = wxDefaultSize,
                 long style = wxHW_DEFAULT_STYLE,
                 const wxString& name = wxT("htmlWindow"));
    virtual ~HTMLButton();

    void initialize();

    void setStyleHTML(const wxString& style, const wxString& html);
    void setHTML(const wxString& html);
    void activateStyle(const wxString& style);
    void simClick();
};


#endif // _HTML_BUTTON_H_
