#ifdef HAVE_ALSA

#ifndef __XSESSION_H__
#define __XSESSION_H__

#include <alsa/asoundlib.h>
#include "speciallist.h"
#include <pthread.h>

#define XSESSION_FADER_1 12
#define XSESSION_FADER_2 11
#define XSESSION_FADER_3 15
#define XSESSION_FADER_4 14

#define XSESSION_POTI_1_1 24
#define XSESSION_POTI_1_2 25
#define XSESSION_POTI_1_3 26

#define XSESSION_POTI_2_1 27
#define XSESSION_POTI_2_2 28
#define XSESSION_POTI_2_3 29

#define XSESSION_POTI_3_1 31
#define XSESSION_POTI_3_2 32
#define XSESSION_POTI_3_3 33

#define XSESSION_POTI_4_1 34
#define XSESSION_POTI_4_2 35
#define XSESSION_POTI_4_3 36

#define XSESSION_CROSSFADER_1 17
#define XSESSION_CROSSFADER_2 20


typedef struct _xsession_info{
  	pthread_t     	xsessionthread;
  	snd_seq_t     	*seq;
  	int           	seq_nfds;
  	struct pollfd 	*pfds;
	speciallist_t	*looperdatalist;
	int		input;
	int 		quit;
} xsession_info_t;

xsession_info_t* xsession_new (speciallist_t* looperdatalist, snd_seq_t *seq);
void         xsession_destroy ();

#endif /* __XSESSION_H__ */
#endif /* HAVE_ALSA */


