/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.authorization;

import org.apache.webdav.lib.Privilege;

public class DSIPrivilege {
    public static String READ = "read";
    public static String READ_ACL = "read_acl";
    public static String WRITE = "write";
    public static String WRITE_ACL = "write_acl";
    public static String ALL = "all";
    protected String mName;
    protected int mInheritanceLevel;
    protected boolean mDeny;

    public DSIPrivilege(String name, int inheritanceLevel, boolean deny) {
        this.mName = new String(name);
        this.mInheritanceLevel = inheritanceLevel;
        this.mDeny = deny;
    }

    public DSIPrivilege(DSIPrivilege priv) {
        this.mName = priv.mName;
        this.mInheritanceLevel = priv.mInheritanceLevel;
        this.mDeny = priv.mDeny;
    }

    public String getName() {
        return this.mName;
    }

    public int getInheritanceLevel() {
        return this.mInheritanceLevel;
    }

    public boolean getDeny() {
        return this.mDeny;
    }

    public static String convertSlidePrivilege(Privilege curPriv) {
        String privName = null;
        if (curPriv != null) {
            if (curPriv.equals(Privilege.ALL)) {
                privName = ALL;
            } else if (curPriv.equals(Privilege.READ)) {
                privName = READ;
            } else if (curPriv.equals(Privilege.READ_ACL)) {
                privName = READ_ACL;
            } else if (curPriv.equals(Privilege.WRITE)) {
                privName = WRITE;
            } else if (curPriv.equals(Privilege.WRITE_ACL)) {
                privName = WRITE_ACL;
            }
        }
        return privName;
    }

    public static Privilege convertDsiPrivilege(DSIPrivilege curPriv) {
        Privilege priv = null;
        if (curPriv != null) {
            String privName = curPriv.getName();
            priv = DSIPrivilege.convertDsiPrivilege(privName);
        }
        return priv;
    }

    public static Privilege convertDsiPrivilege(String privName) {
        Privilege priv = null;
        if (privName != null) {
            if (privName.equals(ALL)) {
                priv = Privilege.ALL;
            } else if (privName.equals(READ)) {
                priv = Privilege.READ;
            } else if (privName.equals(READ_ACL)) {
                priv = Privilege.READ_ACL;
            } else if (privName.equals(WRITE)) {
                priv = Privilege.WRITE;
            } else if (privName.equals(WRITE_ACL)) {
                priv = Privilege.WRITE_ACL;
            }
        }
        return priv;
    }
}

