/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.mailet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.mailet.GenericMailet;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.turbine.util.Log;
import org.chefproject.core.ContentResource;
import org.chefproject.core.MailArchiveChannel;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.User;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.ContentHostingService;
import org.chefproject.service.MailArchiveService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.util.Reference;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;
import org.chefproject.util.Validator;

public class ChefMailet
extends GenericMailet {
    public static final String POSTMASTER = "postmaster";

    public void init() throws MessagingException {
        Log.info("chef", (Object)((Object)this) + ".init()");
    }

    public void destroy() {
        Log.info("chef", (Object)((Object)this) + ".destroy()");
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Mail mail) throws MessagingException {
        UsageSessionService.loginThreadUser(POSTMASTER);
        try {
            MimeMessage msg = mail.getMessage();
            Address[] fromAddresses = msg.getFrom();
            String from = null;
            String fromAddr = null;
            if (fromAddresses != null && fromAddresses.length == 1) {
                from = fromAddresses[0].toString();
                if (fromAddresses[0] instanceof InternetAddress) {
                    fromAddr = ((InternetAddress)fromAddresses[0]).getAddress();
                }
            } else {
                from = mail.getSender().toString();
                fromAddr = mail.getSender().toInternetAddress().getAddress();
            }
            Collection to = mail.getRecipients();
            Date sent = msg.getSentDate();
            String subject = StringUtil.trimToNull(msg.getSubject());
            if (subject == null) {
                subject = "<no subject>";
            }
            Enumeration headers = msg.getAllHeaderLines();
            Vector<String> mailHeaders = new Vector<String>();
            while (headers.hasMoreElements()) {
                String line = (String)headers.nextElement();
                mailHeaders.add(line);
            }
            String body = "";
            ReferenceVector attachments = new ReferenceVector();
            try {
                Object mbody = msg.getContent();
                if (mbody instanceof String) {
                    body = (String)mbody;
                } else if (mbody instanceof MimeMultipart) {
                    StringBuffer bodyBuf = new StringBuffer();
                    MimeMultipart mimeBody = (MimeMultipart)mbody;
                    int count = mimeBody.getCount();
                    int i = 0;
                    while (i < count) {
                        MimeBodyPart mimePart = (MimeBodyPart)mimeBody.getBodyPart(i);
                        String type = mimePart.getContentType();
                        ContentType cType = new ContentType(type);
                        String name = mimePart.getFileName();
                        int size = mimePart.getSize();
                        if (cType.getPrimaryType().equals("text") && name == null) {
                            bodyBuf.append(mimePart.getContent());
                        } else {
                            byte[] bodyBytes;
                            if (name == null) {
                                name = "unknown";
                            }
                            if ((bodyBytes = this.readBody(size, mimePart.getInputStream())) != null && bodyBytes.length > 0) {
                                Reference attachment = this.createAttachment(attachments, cType.getBaseType(), name, bodyBytes);
                            }
                        }
                        ++i;
                    }
                    body = bodyBuf.toString();
                }
            }
            catch (IOException e) {
                Log.warn("chef", (Object)((Object)this) + ".service(): msg.getContent() threw: " + e);
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", (Object)((Object)this) + ": we've got mail: from:" + from + " sent: " + new Time(sent.getTime()).toStringLocalFull() + " subject: " + subject);
            }
            Iterator it = to.iterator();
            while (it.hasNext()) {
                String mailId = null;
                try {
                    MailAddress recipient = (MailAddress)it.next();
                    if (Log.getLogger("chef").isDebugEnabled()) {
                        Log.debug("chef", (Object)((Object)this) + ": to: " + recipient);
                    }
                    mailId = recipient.getUser();
                    MailArchiveChannel channel = null;
                    String ref = MailArchiveService.channelReference(mailId, "main");
                    channel = MailArchiveService.getMailArchiveChannel(ref);
                    if (!channel.getEnabled()) continue;
                    if (!channel.getOpen()) {
                        try {
                            User user = UserDirectoryService.findUserByEmail(fromAddr);
                            UsageSessionService.loginThreadUser(user.getId());
                            boolean allowed = channel.allowAddMessage();
                            UsageSessionService.loginThreadUser(POSTMASTER);
                            if (!allowed) {
                            }
                        }
                        catch (IdUnusedException e) {}
                        continue;
                    }
                    channel.addMailArchiveMessage(subject, from.toString(), new Time(sent.getTime()), mailHeaders, attachments, body);
                    mail.setState("ghost");
                }
                catch (IdUnusedException ignore) {
                }
                catch (PermissionException e) {
                    Log.warn("chef", (Object)((Object)this) + ".service(): " + e);
                }
            }
            Object var26_32 = null;
        }
        catch (Throwable throwable) {
            Object var26_33 = null;
            UsageSessionService.logoutThreadUser();
            throw throwable;
        }
        UsageSessionService.logoutThreadUser();
    }

    private Reference createAttachment(ReferenceVector attachments, String type, String fileName, byte[] body) {
        String name = Validator.getFileName(fileName);
        ResourcePropertiesEdit props = ContentHostingService.newResourceProperties();
        props.addProperty("DAV:displayname", name);
        props.addProperty("CHEF:description", fileName);
        try {
            ContentResource attachment = ContentHostingService.addAttachmentResource(name, type, body, props);
            Reference ref = new Reference(attachment.getReference());
            attachments.add(ref);
            return ref;
        }
        catch (Exception any) {
            Log.warn("chef", (Object)((Object)this) + ".doAdd: exception adding attachment resource (fileName: " + name + "): " + any.toString());
            return null;
        }
    }

    protected byte[] readBody(int size, InputStream stream) {
        if (size <= 0) {
            return null;
        }
        byte[] byteContent = new byte[size];
        try {
            int lenRead = 0;
            while (lenRead < size) {
                int count = stream.read(byteContent, lenRead, size - lenRead);
                if (count > 0) {
                    lenRead += count;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Log.warn("chef", (Object)((Object)this) + "readBody(): " + e);
        }
        return byteContent;
    }

    static {
        POSTMASTER = POSTMASTER;
    }
}

