/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.Calendar;
import org.chefproject.core.CalendarEvent;
import org.chefproject.core.CandidateInfo;
import org.chefproject.core.CandidatePath;
import org.chefproject.core.Dissertation;
import org.chefproject.core.DissertationStep;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.StepStatus;
import org.chefproject.core.User;
import org.chefproject.exception.EmptyException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.PermissionException;
import org.chefproject.exception.TypeException;
import org.chefproject.service.CalendarService;
import org.chefproject.service.ContentHostingService;
import org.chefproject.service.DissertationService;
import org.chefproject.service.RealmService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.generic.GenericAnnouncementService;
import org.chefproject.service.generic.GenericAssignmentService;
import org.chefproject.service.generic.GenericCalendarService;
import org.chefproject.service.generic.GenericChatService;
import org.chefproject.service.generic.GenericContentHostingService;
import org.chefproject.service.generic.GenericDiscussionService;
import org.chefproject.service.generic.GenericDissertationService;
import org.chefproject.service.generic.GenericMailArchiveService;
import org.chefproject.service.generic.GenericMessageService;
import org.chefproject.service.generic.GenericPortalService;
import org.chefproject.service.generic.GenericRealmService;
import org.chefproject.service.generic.GenericSiteService;
import org.chefproject.service.generic.GenericUserDirectoryService;
import org.chefproject.util.StringUtil;

public class Reference {
    protected String m_reference = null;
    protected String m_type = null;
    protected String m_subType = null;
    protected String m_id = null;
    protected String m_container = null;
    protected String m_container2 = null;
    protected String m_context = null;

    public Reference(String ref) {
        this.m_reference = ref;
        this.parse();
    }

    public Reference(Reference ref) {
        this.m_reference = ref.m_reference;
        this.m_type = ref.m_type;
        this.m_subType = ref.m_subType;
        this.m_id = ref.m_id;
        this.m_container = ref.m_container;
        this.m_container2 = ref.m_container2;
        this.m_context = ref.m_context;
    }

    public String getReference() {
        return this.m_reference;
    }

    public String getType() {
        return this.m_type;
    }

    public String getSubType() {
        return this.m_subType;
    }

    public String getId() {
        return this.m_id;
    }

    public String getContainer() {
        return this.m_container;
    }

    public String getContainer2() {
        return this.m_container2;
    }

    public String getContext() {
        return this.m_context;
    }

    public ResourceProperties getProperties() {
        ResourceProperties props;
        block33: {
            props = null;
            if (this.m_type.equals(GenericContentHostingService.SERVICE_NAME)) {
                try {
                    props = ContentHostingService.getProperties(this.m_id);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
            } else if (this.m_type.equals(GenericChatService.SERVICE_NAME) || this.m_type.equals(GenericAnnouncementService.SERVICE_NAME) || this.m_type.equals(GenericDiscussionService.SERVICE_NAME) || this.m_type.equals(GenericMailArchiveService.SERVICE_NAME)) {
                GenericMessageService service = (GenericMessageService)((Object)TurbineServices.getInstance().getService(this.m_type));
                try {
                    if ("channel".equals(this.m_subType)) {
                        MessageChannel channel = service.getChannel(this.m_reference);
                        props = channel.getProperties();
                        break block33;
                    }
                    if ("msg".equals(this.m_subType)) {
                        MessageChannel channel = service.getChannel(service.channelReference(this.m_context, this.m_container));
                        Message message = channel.getMessage(this.m_id);
                        props = message.getProperties();
                        break block33;
                    }
                    Log.warn("chef", this + "getProperties(): unknown message ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
            } else if (this.m_type.equals(GenericCalendarService.SERVICE_NAME)) {
                try {
                    if ("calendar".equals(this.m_subType)) {
                        Calendar cal = CalendarService.getCalendar(this.m_reference);
                        props = cal.getProperties();
                        break block33;
                    }
                    if ("event".equals(this.m_subType)) {
                        Calendar cal = CalendarService.getCalendar(CalendarService.calendarReference(this.m_context, this.m_container));
                        CalendarEvent event = cal.getEvent(this.m_id);
                        props = event.getProperties();
                        break block33;
                    }
                    Log.warn("chef", this + "getProperties(): unknown calendar ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
            } else if (this.m_type.equals(GenericDissertationService.SERVICE_NAME)) {
                try {
                    if ("d".equals(this.m_subType)) {
                        Dissertation dissertation = DissertationService.getDissertation(this.m_reference);
                        props = dissertation.getProperties();
                    } else if ("s".equals(this.m_subType)) {
                        DissertationStep step = DissertationService.getDissertationStep(this.m_reference);
                        props = step.getProperties();
                    } else if ("p".equals(this.m_subType)) {
                        CandidatePath path = DissertationService.getCandidatePath(this.m_reference);
                        props = path.getProperties();
                    } else if ("ss".equals(this.m_subType)) {
                        StepStatus status = DissertationService.getStepStatus(this.m_reference);
                        props = status.getProperties();
                    } else if ("i".equals(this.m_subType)) {
                        CandidateInfo info = DissertationService.getCandidateInfo(this.m_reference);
                        props = info.getProperties();
                    } else {
                        Log.warn("chef", this + "getProperties(): unknown message ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                    }
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
            }
        }
        return props;
    }

    public Resource getResource() {
        Resource r;
        block39: {
            r = null;
            if (this.m_type.equals(GenericContentHostingService.SERVICE_NAME)) {
                try {
                    ResourceProperties props = ContentHostingService.getProperties(this.m_id);
                    if (props.getBooleanProperty("CHEF:is-collection")) {
                        r = ContentHostingService.getCollection(this.m_id);
                        break block39;
                    }
                    r = ContentHostingService.getResource(this.m_id);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
                catch (TypeException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
                catch (EmptyException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
            } else if (this.m_type.equals(GenericChatService.SERVICE_NAME) || this.m_type.equals(GenericAnnouncementService.SERVICE_NAME) || this.m_type.equals(GenericDiscussionService.SERVICE_NAME) || this.m_type.equals(GenericMailArchiveService.SERVICE_NAME)) {
                GenericMessageService service = (GenericMessageService)((Object)TurbineServices.getInstance().getService(this.m_type));
                try {
                    if ("channel".equals(this.m_subType)) {
                        r = service.getChannel(this.m_reference);
                        break block39;
                    }
                    if ("msg".equals(this.m_subType)) {
                        MessageChannel channel = service.getChannel(service.channelReference(this.m_context, this.m_container));
                        r = channel.getMessage(this.m_id);
                        break block39;
                    }
                    Log.warn("chef", this + "getResource(): unknown message ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
            } else if (this.m_type.equals(GenericCalendarService.SERVICE_NAME)) {
                try {
                    if ("calendar".equals(this.m_subType)) {
                        r = CalendarService.getCalendar(this.m_reference);
                        break block39;
                    }
                    if ("event".equals(this.m_subType)) {
                        Calendar cal = CalendarService.getCalendar(CalendarService.calendarReference(this.m_context, this.m_container));
                        r = cal.getEvent(this.m_id);
                        break block39;
                    }
                    Log.warn("chef", this + "getProperties(): unknown calendar ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
            } else if (this.m_type.equals(GenericDissertationService.SERVICE_NAME)) {
                try {
                    if ("d".equals(this.m_subType)) {
                        r = DissertationService.getDissertation(this.m_reference);
                    } else if ("s".equals(this.m_subType)) {
                        r = DissertationService.getDissertationStep(this.m_reference);
                    } else if ("p".equals(this.m_subType)) {
                        r = DissertationService.getCandidatePath(this.m_reference);
                    } else if ("ss".equals(this.m_subType)) {
                        r = DissertationService.getStepStatus(this.m_reference);
                    } else if ("i".equals(this.m_subType)) {
                        r = DissertationService.getCandidateInfo(this.m_reference);
                    } else {
                        Log.warn("chef", this + "getResource(): unknown message ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                    }
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getResource(): ", (Throwable)e);
                }
            }
        }
        if (this.m_type.equals(GenericSiteService.SERVICE_NAME)) {
            try {
                r = SiteService.getSite(this.m_id);
            }
            catch (IdUnusedException e) {
                Log.warn("chef", this + "getResource(): ", (Throwable)e);
            }
        }
        return r;
    }

    public String getUrl() {
        String url;
        block30: {
            url = null;
            if (this.m_type.equals(GenericContentHostingService.SERVICE_NAME)) {
                url = ContentHostingService.getUrl(this.m_id);
            } else if (this.m_type.equals(GenericChatService.SERVICE_NAME) || this.m_type.equals(GenericAnnouncementService.SERVICE_NAME) || this.m_type.equals(GenericDiscussionService.SERVICE_NAME) || this.m_type.equals(GenericMailArchiveService.SERVICE_NAME)) {
                GenericMessageService service = (GenericMessageService)((Object)TurbineServices.getInstance().getService(this.m_type));
                try {
                    if ("channel".equals(this.m_subType)) {
                        MessageChannel channel = service.getChannel(this.m_reference);
                        url = channel.getUrl();
                        break block30;
                    }
                    if ("msg".equals(this.m_subType)) {
                        MessageChannel channel = service.getChannel(service.channelReference(this.m_context, this.m_container));
                        Message message = channel.getMessage(this.m_id);
                        url = message.getUrl();
                        break block30;
                    }
                    Log.warn("chef", this + "getUrl(): unknown message ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getUrl(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getUrl(): ", (Throwable)e);
                }
            } else if (this.m_type.equals(GenericCalendarService.SERVICE_NAME)) {
                try {
                    if ("calendar".equals(this.m_subType)) {
                        Calendar cal = CalendarService.getCalendar(this.m_reference);
                        url = cal.getUrl();
                        break block30;
                    }
                    if ("event".equals(this.m_subType)) {
                        Calendar cal = CalendarService.getCalendar(CalendarService.calendarReference(this.m_context, this.m_container));
                        CalendarEvent event = cal.getEvent(this.m_id);
                        url = event.getUrl();
                        break block30;
                    }
                    Log.warn("chef", this + "getUrl(): unknown calendar ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getProperties(): ", (Throwable)e);
                }
            } else if (this.m_type.equals(GenericDissertationService.SERVICE_NAME)) {
                try {
                    if ("d".equals(this.m_subType)) {
                        Dissertation dissertation = DissertationService.getDissertation(this.m_reference);
                        url = dissertation.getUrl();
                    } else if ("s".equals(this.m_subType)) {
                        DissertationStep step = DissertationService.getDissertationStep(this.m_reference);
                        url = step.getUrl();
                    } else if ("p".equals(this.m_subType)) {
                        CandidatePath path = DissertationService.getCandidatePath(this.m_reference);
                        url = path.getUrl();
                    } else if ("ss".equals(this.m_subType)) {
                        StepStatus status = DissertationService.getStepStatus(this.m_reference);
                        url = status.getUrl();
                    } else if ("i".equals(this.m_subType)) {
                        CandidateInfo info = DissertationService.getCandidateInfo(this.m_reference);
                        url = info.getUrl();
                    } else {
                        Log.warn("chef", this + "getUrl(): unknown message ref subtype: " + this.m_subType + " in ref: " + this.m_reference);
                    }
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + "getUrl(): ", (Throwable)e);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + "getUrl(): ", (Throwable)e);
                }
            }
        }
        return url;
    }

    public List getRealms() {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".getRealms: for ref: " + this.getReference());
        }
        Vector rv = new Vector();
        if (this.getType().equals(GenericContentHostingService.SERVICE_NAME)) {
            String[] paths = StringUtil.split(this.getId(), "/");
            boolean container = this.getId().endsWith("/");
            if (paths.length > 1) {
                String root = ContentHostingService.getReference("/" + paths[1] + "/");
                this.addRealm(rv, root);
                int next = 2;
                while (next < paths.length) {
                    root = root + paths[next];
                    if (next < paths.length - 1 || container) {
                        root = root + "/";
                    }
                    this.addRealm(rv, root);
                    ++next;
                }
            }
            this.addContentHostingSiteRealm(rv);
        } else if (this.getType().equals(GenericChatService.SERVICE_NAME) || this.getType().equals(GenericAnnouncementService.SERVICE_NAME) || this.getType().equals(GenericDiscussionService.SERVICE_NAME) || this.getType().equals(GenericMailArchiveService.SERVICE_NAME)) {
            GenericMessageService service = (GenericMessageService)((Object)TurbineServices.getInstance().getService(this.getType()));
            String channelId = null;
            if ("msg".equals(this.getSubType())) {
                this.addRealm(rv, this.getReference());
                channelId = this.getContainer();
            } else {
                channelId = this.getId();
            }
            this.addRealm(rv, service.channelReference(this.getContext(), channelId));
            this.addSiteRealm(rv, this.getContext());
        } else if (this.getType().equals(GenericCalendarService.SERVICE_NAME)) {
            String calendarId = null;
            if ("event".equals(this.getSubType())) {
                this.addRealm(rv, this.getReference());
                calendarId = this.getContainer();
            } else {
                calendarId = this.getId();
            }
            this.addRealm(rv, CalendarService.calendarReference(this.getContext(), calendarId));
            this.addSiteRealm(rv, this.getContext());
        } else if (this.getType().equals(GenericPortalService.SERVICE_NAME)) {
            if ("group".equals(this.getContainer())) {
                this.addRealm(rv, SiteService.siteReference(this.getId()));
            } else if ("user".equals(this.getContainer())) {
                this.addRealm(rv, SiteService.siteReference(SiteService.getUserSiteId(this.getId())));
            } else if ("role".equals(this.getContainer()) && "user".equals(this.getId())) {
                this.addRealm(rv, SiteService.siteReference(SiteService.getUserSiteId(UsageSessionService.getSessionUser().getId())));
            } else {
                this.addRealm(rv, SiteService.siteReference(SiteService.getSpecialSiteId(this.getContainer() + "-" + this.getId())));
            }
        } else if (this.getType().equals(GenericSiteService.SERVICE_NAME)) {
            this.addRealm(rv, this.getReference());
            this.addRealm(rv, SiteService.siteReference(""));
        } else if (this.getType().equals(GenericUserDirectoryService.SERVICE_NAME)) {
            this.addRealm(rv, SiteService.siteReference(SiteService.getUserSiteId(this.getId())));
        } else if (this.getType().equals(GenericRealmService.SERVICE_NAME)) {
            this.addRealm(rv, this.getReference());
            this.addRealm(rv, RealmService.realmReference(""));
        } else if (this.getType().equals(GenericAssignmentService.SERVICE_NAME)) {
            this.addRealm(rv, this.getReference());
            this.addSiteRealm(rv, this.getContext());
        } else if (this.getType().equals(GenericDissertationService.SERVICE_NAME)) {
            String reference = this.getReference();
            this.addRealm(rv, reference);
            String schoolRef = "/dissertation/" + this.getSubType() + "/" + this.getContainer();
            this.addRealm(rv, schoolRef);
            this.addSiteRealm(rv, this.getContext());
        }
        return rv;
    }

    protected void addRealm(List rv, String id) {
        try {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".addRealm: " + id);
            }
            rv.add(RealmService.getRealm(id));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (id.startsWith(SiteService.siteReference(SiteService.getUserSiteId("")))) {
            String realmUser = id.substring(SiteService.siteReference(SiteService.getUserSiteId("")).length());
            User currentUser = UsageSessionService.getSessionUser();
            if (currentUser.getId().equals(realmUser) || currentUser.equals(UserDirectoryService.getAnonymousUser())) {
                try {
                    if (Log.getLogger("chef").isDebugEnabled()) {
                        Log.debug("chef", this + ".addRealm: " + "~");
                    }
                    rv.add(RealmService.getRealm("~"));
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
    }

    protected void addSiteRealm(List rv, String site) {
        this.addRealm(rv, SiteService.siteReference(site));
    }

    protected void addContentHostingSiteRealm(List rv) {
        this.addRealm(rv, SiteService.siteReference(this.getContext()));
        String[] parts = StringUtil.split(this.getId(), "/");
        if (parts.length >= 3 && parts[1].equals("group-user") && parts.length > 3) {
            this.addRealm(rv, SiteService.siteReference(SiteService.getUserSiteId(parts[3])));
        }
    }

    protected void parse() {
        String[] parts;
        String contentAccessBase = ContentHostingService.getUrl("");
        if (this.m_reference != null && this.m_reference.startsWith("/content")) {
            this.m_id = this.m_reference.substring("/content".length(), this.m_reference.length());
            this.m_type = GenericContentHostingService.SERVICE_NAME;
        } else if (this.m_reference != null && this.m_reference.startsWith(contentAccessBase)) {
            this.m_id = this.m_reference.substring(contentAccessBase.length(), this.m_reference.length());
            this.m_type = GenericContentHostingService.SERVICE_NAME;
        } else if (this.m_reference != null && (this.m_reference.startsWith("/chat") || this.m_reference.startsWith("/announcement") || this.m_reference.startsWith("/discussion") || this.m_reference.startsWith("/mailarchive"))) {
            parts = StringUtil.split(this.m_reference, "/");
            if (parts.length > 2) {
                this.m_subType = parts[2];
                if ("channel".equals(this.m_subType)) {
                    if (parts.length > 3) {
                        this.m_context = parts[3];
                        if (parts.length > 4) {
                            this.m_id = parts[4];
                        }
                    }
                } else if ("msg".equals(this.m_subType)) {
                    if (parts.length > 5) {
                        this.m_context = parts[3];
                        this.m_container = parts[4];
                        this.m_id = parts[5];
                    }
                } else {
                    Log.warn("chef", this + "parse(): unknown message subtype: " + this.m_subType + " in ref: " + this.m_reference);
                }
            }
            if (this.m_reference.startsWith("/chat")) {
                this.m_type = GenericChatService.SERVICE_NAME;
            } else if (this.m_reference.startsWith("/announcement")) {
                this.m_type = GenericAnnouncementService.SERVICE_NAME;
            } else if (this.m_reference.startsWith("/discussion")) {
                this.m_type = GenericDiscussionService.SERVICE_NAME;
            } else if (this.m_reference.startsWith("/mailarchive")) {
                this.m_type = GenericMailArchiveService.SERVICE_NAME;
            }
        } else if (this.m_reference != null && this.m_reference.startsWith("/calendar")) {
            parts = StringUtil.split(this.m_reference, "/");
            if (parts.length > 2) {
                this.m_subType = parts[2];
                if ("calendar".equals(this.m_subType)) {
                    if (parts.length > 3) {
                        this.m_context = parts[3];
                        if (parts.length > 4) {
                            this.m_id = parts[4];
                        }
                    }
                } else if ("event".equals(this.m_subType)) {
                    if (parts.length > 5) {
                        this.m_context = parts[3];
                        this.m_container = parts[4];
                        this.m_id = parts[5];
                    }
                } else {
                    Log.warn("chef", this + "parse(): unknown calendar subtype: " + this.m_subType + " in ref: " + this.m_reference);
                }
            }
            this.m_type = GenericCalendarService.SERVICE_NAME;
        } else if (this.m_reference != null && this.m_reference.startsWith("/site")) {
            parts = StringUtil.split(this.m_reference, "/");
            if (parts.length > 2) {
                this.m_id = parts[2];
            }
            this.m_type = GenericSiteService.SERVICE_NAME;
        } else if (this.m_reference != null && this.m_reference.startsWith("/user")) {
            parts = StringUtil.split(this.m_reference, "/");
            if (parts.length > 2) {
                this.m_id = parts[2];
            }
            this.m_type = GenericUserDirectoryService.SERVICE_NAME;
        } else if (this.m_reference != null && this.m_reference.startsWith("/realm")) {
            this.m_id = this.m_reference.substring("/realm".length(), this.m_reference.length());
            this.m_type = GenericRealmService.SERVICE_NAME;
        } else if (this.m_reference != null && this.m_reference.startsWith("/assignment")) {
            parts = StringUtil.split(this.m_reference, "/");
            if (parts.length > 2) {
                this.m_subType = parts[2];
                if (parts.length > 3) {
                    this.m_context = parts[3];
                    if ("s".equals(this.m_subType)) {
                        if (parts.length > 5) {
                            this.m_container = parts[4];
                            this.m_id = parts[5];
                        }
                    } else if (parts.length > 4) {
                        this.m_id = parts[4];
                    }
                }
            }
            this.m_type = GenericAssignmentService.SERVICE_NAME;
        } else if (this.m_reference != null && this.m_reference.startsWith("/dissertation")) {
            parts = StringUtil.split(this.m_reference, "/");
            if (parts.length > 2) {
                this.m_subType = parts[2];
                if (parts.length > 3) {
                    this.m_container = parts[3];
                    if (parts.length > 4) {
                        this.m_context = parts[4];
                        if (parts.length > 5) {
                            this.m_id = parts[5];
                        }
                    }
                }
            }
            this.m_type = GenericDissertationService.SERVICE_NAME;
        } else {
            Log.warn("chef", this + ".parse(): unhandled reference: " + this.m_reference);
        }
        if (GenericContentHostingService.SERVICE_NAME.equals(this.m_type) && (parts = StringUtil.split(this.m_id, "/")).length >= 3) {
            if (parts[1].equals("group")) {
                this.m_context = parts[2];
            } else if (parts[1].equals("user")) {
                this.m_context = SiteService.getUserSiteId(parts[2]);
            } else if (parts[1].equals("group-user")) {
                this.m_context = parts[2];
            }
        }
    }
}

