/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scidac.cmcs.tools.pertable.PertableElementComparator;

public class BasisSetMerge {
    protected static final Namespace bseNS = Namespace.getNamespace("http://purl.oclc.org/NET/EMSL/BSE");
    protected static Comparator mComparator = PertableElementComparator.newInstance();

    public static void main(String[] args) {
        String origSet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>  <basisSet    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"   xmlns:dc=\"http://purl.org/dc/elements/1.1/\"   xmlns:cml=\"http://www.xml-cml.org/schema/cml2/core\"   xmlns:xlink=\"http://www.w3.org/1999/xlink\"   xmlns:dct=\"http://purl.org/dc/terms/\"   xmlns=\"http://purl.oclc.org/NET/EMSL/BSE\">    <dc:format>chemical/x-emsl-gaussian-basisset</dc:format>   <dc:title>6-31G</dc:title>   <dct:abstract>VDZ     Valence Double Zeta: 2 Funct.'s/Valence AO</dct:abstract>   <conversion>true</conversion>   <basisSetType>orbital</basisSetType>   <harmonicType>cartesian</harmonicType>   <contractionType>segmented</contractionType>    <dc:description><![CDATA[                           6-31G Split Valence Basis                            ------------------------- Elements      Contraction                       References  H - He: (4s)        -> [2s]       W.J. Hehre, R. Ditchfield and J.A. Pople, Li - Ne: (10s,4p)    -> [3s,2p]    J. Chem. Phys. 56, 2257 (1972).                                    Note: Li and B come from J.D. Dill and J.A.                                          Pople, J. Chem. Phys. 62, 2921 (1975) Na - Ar: (16s,10p)   -> [4s,3p]    M.M. Francl, W.J. Petro, W.J. Hehre, J.S.                                    Binkley, M.S. Gordon, D.J. DeFrees and J.A.                                    Pople, J. Chem. Phys. 77, 3654 (1982) K  - Ca: (22s,16p)   -> [5s,4p]    V. Rassolov, J.A. Pople, M. Ratner and Sc - Zn: (22s,16p,4d)-> [5s,4p,2d] T.L. Windus, J. Chem. Phys. 109, 1223                                    (1998).                                    Note: He and Ne are unpublished basis sets                                          taken from the Gaussian program.  The 6-31G basis set uses 6 Gaussian primitives to expand the 1s core of second period elements.                           6-31G Atomic Energies                                                     ROHF    State  UHF (noneq) ROHF (noneq)  ROHF(equiv)   HF Limit (equiv)    -----  ----------  -----------   -----------   --------- H   2-S    -0.498233    -0.498233    -0.498233     -0.50000 He  1-S    -2.855160    -2.855160    -2.855160     -2.86168 Li  2-S    -7.431236    -7.431236    -7.431236     -7.43273 Be  1-S   -14.566764   -14.566764   -14.566764    -14.57302 B   2-P   -24.519492   -24.519348                 -24.52906 C   3-P   -37.677837   -37.676865                 -37.68862 N   4-S   -54.385008   -54.382051                 -54.40094 O   3-P   -74.780310                              -74.80940 F   2-P   -99.360859   -99.360218                 -99.40935 Ne  1-S  -127.132546  -127.803824                -128.54710 Na  2-S                                          -161.85891 Mg  1-S                                          -199.61463 Al  2-P  -241.854186  -241.854168                -241.87671 Si  3-P  -288.828432  -288.828425                -288.85436 P   4-S  -340.689008  -340.688936                -340.71878 S   3-P  -397.471414  -397.471064                -397.50490 Cl  2-P  -459.442939  -459.442771                -459.48207 Ar  1-S                                          -526.81751 K   2-S                                          -599.16479 Ca  1-S                                          -676.75817 Sc  2-D                            -759.6729180  -759.73572 Ti  3-F                            -848.3273288  -848.40600 V   4-F                            -942.7864053  -942.88433 Cr  7-S                           -1043.1889497 -1043.35636 Mn  6-S                           -1149.7192068 -1149.86624 Fe  5-D                           -1262.2625445 -1262.44366 Co  4-F                           -1381.1952242 -1381.41454 Ni  3-F                           -1506.6081800 -1506.87089 Cu  2-S                           -1638.6384752 -1638.96371 Zn  1-S                           -1777.4827534 -1777.84810  ]]></dc:description>    <referencesLink xlink:type=\"simple\" xlink:href=\"6-31G-BS-REF.xml\"/>    <contractions elementType=\"H\">     <dc:description>(4s)->[2s]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 18.731137 0.03349460  2.8253937 0.23472695  0.6401217 0.81375733         </cml:matrix>     </contraction>     <contraction shell=\"S\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.1612778 1.00000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"He\">     <dc:description>(4s)->[2s]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 38.421634 0.0237660  5.7780300 0.1546790  1.2417740 0.4696300         </cml:matrix>     </contraction>     <contraction shell=\"S\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.2979640 1.0000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Li\">     <dc:description>(10s,4p)->[3s,2p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 642.41892 0.0021426  96.798515 0.0162089  22.091121 0.0773156  6.2010703 0.2457860  1.9351177 0.4701890  0.6367358 0.3454708         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 2.3249184 -0.0350917 0.0089415  0.6324306 -0.1912328 0.1410095  0.0790534 1.0839878 0.9453637         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.0359620 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Be\">     <dc:description>(10s,4p)->[3s,2p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 1264.5857 0.0019448  189.93681 0.0148351  43.159089 0.0720906  12.098663 0.2371542  3.8063232 0.4691987  1.2728903 0.3565202         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 3.1964631 -0.1126487 0.0559802  0.7478133 -0.2295064 0.2615506  0.2199663 1.1869167 0.7939723         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.0823099 1.0000000 1.0000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"B\">     <dc:description>(10s,4p)->[3s,2p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 2068.8823 0.0018663  310.64957 0.0142515  70.683033 0.0695516  19.861080 0.2325729  6.2993048 0.4670787  2.1270270 0.3634314         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 4.7279710 -0.1303938 0.0745976  1.1903377 -0.1307889 0.3078467  0.3594117 1.1309444 0.7434568         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.1267512 1.0000000 1.0000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"C\">     <dc:description>(10s,4p)->[3s,2p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 3047.5249 0.0018347  457.36951 0.0140373  103.94869 0.0688426  29.210155 0.2321844  9.2866630 0.4679413  3.1639270 0.3623120         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 7.8682724 -0.1193324 0.0689991  1.8812885 -0.1608542 0.3164240  0.5442493 1.1434564 0.7443083         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.1687144 1.0000000 1.0000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"N\">     <dc:description>(10s,4p)->[3s,2p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 4173.5110 0.0018348  627.4579 0.013995  142.9021 0.068587  40.23433 0.232241  12.82021 0.469070  4.390437 0.360455         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 11.626358 -0.114961 0.067580  2.716280 -0.169118 0.323907  0.772218 1.145852 0.740895         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.2120313 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"O\">     <dc:description>(10s,4p)->[3s,2p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 5484.6717 0.0018311  825.23495 0.0139501  188.04696 0.0684451  52.964500 0.2327143  16.897570 0.4701930  5.7996353 0.3585209         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 15.539616 -0.1107775 0.0708743  3.5999336 -0.1480263 0.3397528  1.0137618 1.1307670 0.7271586         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.2700058 1.0000000 1.0000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"F\">     <dc:description>(10s,4p)->[3s,2p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 7001.71309 0.0018196169  1051.36609 0.0139160796  239.285690 0.0684053245  67.3974453 0.233185760  21.5199573 0.471267439  7.40310130 0.356618546         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 20.8479528 -0.108506975 0.0716287243  4.80830834 -0.146451658 0.3459121030  1.34406986 1.128688580 0.7224699570         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.358151393 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Ne\">     <dc:description>(10s,4p)->[3s,2p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 8425.85153 0.0018843481  1268.51940 0.0143368994  289.621414 0.0701096233  81.8590040 0.2373732660  26.2515079 0.4730071260  9.09472051 0.3484012410         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 26.5321310 -0.107118287 0.0719095885  6.10175501 -0.146163821 0.3495133720  1.69627153 1.127773500 0.7199405120         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.44581870 1.000000 1.0000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Na\">     <dc:description>(16s,10p)->[4s,3p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 9993.200 0.0019377  1499.890 0.0148070  341.9510 0.072706  94.67970 0.252629  29.73450 0.493242  10.00630 0.313169         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 150.9630 -0.0035421 0.0050017  35.58780 -0.0439590 0.035511  11.16830 -0.1097521 0.142825  3.902010 0.187398 0.338620  1.381770 0.646699 0.451579  0.466382 0.306058 0.273271         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 0.4979660 -0.248503 -0.023023  0.084353 -0.131704 0.950359  0.066635 1.233520 0.059858         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.0259544 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Mg\">     <dc:description>(16s,10p)->[4s,3p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 11722.80 0.0019778  1759.930 0.015114  400.8460 0.073911  112.8070 0.249191  35.99970 0.487928  12.18280 0.319662         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 189.1800 -0.0032372 0.0049281  45.21190 -0.041008 0.034989  14.35630 -0.112600 0.140725  5.138860 0.148633 0.333642  1.906520 0.616497 0.444940  0.705887 0.364829 0.269254         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 0.929340 -0.212290 -0.022419  0.269035 -0.107985 0.192270  0.117379 1.175840 0.846181         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.0421061 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Al\">     <dc:description>(16s,10p)->[4s,3p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 13983.1 0.00194267  2098.75 0.0148599  477.705 0.0728494  134.360 0.2468300  42.8709 0.4872580  14.5189 0.3234960         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 239.668 -0.00292619 0.00460285  57.4419 -0.0374080 0.033199  18.2859 -0.114487 0.136282  6.59914 0.115635 0.330476  2.49049 0.612595 0.449146  0.94454 0.393799 0.265704         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.277900 -0.227606 -0.017513  0.397590 0.00144583 0.244533  0.160095 1.092790 0.804934         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.0556577 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Si\">     <dc:description>(16s,10p)->[4s,3p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 16115.9 0.00195948  2425.58 0.01492880  553.867 0.07284780  156.340 0.24613000  50.0683 0.48591400  17.0178 0.32500200         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 292.718 -0.00278094 0.00443826  69.8731 -0.03571460 0.03266790  22.3363 -0.11498500 0.13472100  8.15039 0.09356340 0.32867800  3.13458 0.60301700 0.44964000  1.22543 0.41895900 0.26137200         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.72738 -0.24463000 -0.01779510  0.572922 0.00431572 0.25353900  0.222192 1.09818000 0.80066900         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.0778369 1.00000000 1.00000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"P\">     <dc:description>(16s,10p)->[4s,3p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 19413.3 0.0018516  2909.42 0.0142062  661.364 0.0699995  185.759 0.2400790  59.1943 0.4847620  20.0310 0.3352000         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 339.478 -0.00278217 0.00456462  81.0101 -0.0360499 0.03369360  25.8780 -0.1166310 0.13975500  9.45221 0.0968328 0.33936200  3.66566 0.6144180 0.45092100  1.46746 0.4037980 0.23858600         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 2.156230 -0.2529230 -0.01776530  0.748997 0.0328517 0.27405800  0.283145 1.0812500 0.78542100         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.0998317 1.0000000 1.00000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"S\">     <dc:description>(16s,10p)->[4s,3p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 21917.10 0.001869  3301.490 0.014230  754.1460 0.069696  212.7110 0.238487  67.98960 0.483307  23.05150 0.338074         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 423.7350 -0.0023767 0.004061  100.7100 -0.031693 0.030681  32.15990 -0.113317 0.130452  11.80790 0.056090 0.327205  4.631100 0.592255 0.452851  1.870250 0.455006 0.256042         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 2.615840 -0.250374 -0.014511  0.922167 0.066957 0.310263  0.341287 1.054510 0.754483         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.117167 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Cl\">     <dc:description>(16s,10p)->[4s,3p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 25180.10 0.001833  3780.350 0.014034  860.4740 0.069097  242.1450 0.237452  77.33490 0.483034  26.24700 0.339856         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 491.7650 -0.0022974 0.0039894  116.9840 -0.030714 0.030318  37.41530 -0.112528 0.129880  13.78340 0.045016 0.327951  5.452150 0.589353 0.453527  2.225880 0.465206 0.252154         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 3.186490 -0.251830 -0.014299  1.144270 0.061589 0.323572  0.420377 1.060180 0.743507         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.142657 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Ar\">     <dc:description>(16s,10p)->[4s,3p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 28348.3 0.00182526  4257.62 0.01396860  969.857 0.06870730  273.263 0.23620400  87.3695 0.48221400  29.6867 0.34204300         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 575.891 -0.00215972 0.00380665  136.816 -0.02907750 0.02923050  43.8098 -0.11082700 0.12646700  16.2094 0.02769990 0.32351000  6.46084 0.57761300 0.45489600  2.65114 0.48868800 0.25663000         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 3.86028 -0.2555920 -0.01591970  1.41373 0.0378066 0.32464600  0.516646 1.0805600 0.74399000         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.173888 1.000000 1.000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"K\">     <dc:description>(22s,16p)->[5s,4p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 31594.42 1.828010E-03  4744.330 1.399403E-02  1080.419 6.887129E-02  304.2338 2.369760E-01  97.24586 4.829040E-01  33.02495 3.404795E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 622.7625 -2.502976E-03 4.094637E-03  147.8839 -3.315550E-02 3.145199E-02  47.32735 -1.226387E-01 1.351558E-01  17.51495 5.353643E-02 3.390500E-01  6.922722 6.193860E-01 4.629455E-01  2.768277 4.345878E-01 2.242638E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 11.84802 1.277689E-02 -1.221377E-02  4.079211 2.098767E-01 -6.900537E-03  1.763481 -3.095274E-03 2.007466E-01  0.788927 -5.593884E-01 4.281332E-01  0.350387 -5.134760E-01 3.970156E-01  0.146344 -6.598035E-02 1.104718E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 0.716801 -5.237772E-02 0.0316430  0.233741 -2.798503E-01 -0.0404616  0.038675 1.141547E+00 1.012029         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.016521 1.000000E+00 1.00000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Ca\">     <dc:description>(22s,16p)->[5s,4p]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 35264.86 1.813501E-03  5295.503 1.388493E-02  1206.020 6.836162E-02  339.6839 2.356188E-01  108.6264 4.820639E-01  36.92103 3.429819E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 706.3096 2.448225E-03 4.020371E-03  167.8187 3.241504E-02 3.100601E-02  53.82558 1.226219E-01 1.337279E-01  20.01638 -4.316965E-02 3.367983E-01  7.970279 -6.126995E-01 4.631281E-01  3.212059 -4.487540E-01 2.257532E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 14.19518 1.084500E-02 -1.289621E-02  4.880828 2.088333E-01 -1.025198E-02  2.160390 3.150338E-02 1.959781E-01  0.987899 -5.526518E-01 4.357933E-01  0.449517 -5.437997E-01 3.996452E-01  0.187387 -6.669342E-02 9.713636E-02         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.032271 -4.439720E-02 -0.4298621  0.381171 -3.284563E-01 0.006935829  0.065131 1.163010E+00 0.9705933         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.026010 1.000000E+00 1.00000000         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Sc\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 39088.98 1.803263E-03  5869.792 1.380769E-02  1336.910 6.800396E-02  376.6031 2.347099E-01  120.4679 4.815690E-01  40.98032 3.445652E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 786.2852 2.451863E-03 4.039530E-03  186.8870 3.259579E-02 3.122570E-02  60.00935 1.238242E-01 1.349833E-01  22.25883 -4.359890E-02 3.424793E-01  8.885149 -6.177181E-01 4.623113E-01  3.609211 -4.432823E-01 2.177524E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 29.84355 -2.586302E-03 -6.096652E-03  9.542383 7.188424E-02 -2.628884E-02  4.056790 2.503260E-01 5.091001E-02  1.704703 -2.991003E-01 3.798097E-01  0.706234 -7.446818E-01 5.170883E-01  0.279536 -1.799776E-01 1.829772E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.065609 6.482978E-02 -0.2938440  0.425933 3.253756E-01 0.09235323  0.076320 -1.170806E+00 0.9847930         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.029594 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 11.14701 8.747672E-02  2.821043 3.795635E-01  0.819620 7.180393E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.221468 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Ti\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 43152.95 1.791872E-03  6479.571 1.372392E-02  1475.675 6.762830E-02  415.6991 2.337642E-01  133.0006 4.810696E-01  45.27222 3.462280E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 874.6826 2.431008E-03 4.017679E-03  207.9785 3.233027E-02 3.113966E-02  66.87918 1.242520E-01 1.349077E-01  24.87347 -3.903905E-02 3.431672E-01  9.968441 -6.171789E-01 4.625760E-01  4.063826 -4.473097E-01 2.154603E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 33.64363 -2.940358E-03 -6.311620E-03  10.87565 7.163103E-02 -2.697638E-02  4.628225 2.528915E-01 5.316847E-02  1.950126 -2.966401E-01 3.845549E-01  0.809452 -7.432215E-01 5.127662E-01  0.320474 -1.853520E-01 1.811135E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.224148 6.351465E-02 -0.2112070  0.484263 3.151404E-01 0.07771998  0.084096 -1.162595E+00 0.9898214         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.032036 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 13.69085 8.589418E-02  3.513154 3.784671E-01  1.040434 7.161239E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.286962 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"V\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 47354.33 1.784513E-03  7110.787 1.366754E-02  1619.591 6.736122E-02  456.3379 2.330552E-01  146.0606 4.806316E-01  49.75791 3.474802E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 968.1484 2.410599E-03 3.995005E-03  230.2821 3.207243E-02 3.104061E-02  74.14591 1.245942E-01 1.347747E-01  27.64107 -3.482177E-02 3.437279E-01  11.11475 -6.167374E-01 4.628759E-01  4.543113 -4.509844E-01 2.135547E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 37.64050 -3.233199E-03 -6.494056E-03  12.28238 7.130744E-02 -2.753453E-02  5.233366 2.543820E-01 5.516284E-02  2.208950 -2.933887E-01 3.879672E-01  0.917880 -7.415695E-01 5.090258E-01  0.363412 -1.909410E-01 1.803840E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.392781 6.139703E-02 -0.1891265  0.543913 3.061130E-01 0.08005453  0.091476 -1.154890E+00 0.9877399         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.034312 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 16.05025 8.599899E-02  4.160063 3.802996E-01  1.243265 7.127659E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.344277 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Cr\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 51789.81 1.776182E-03  7776.849 1.360476E-02  1771.385 6.706925E-02  499.1588 2.323104E-01  159.7982 4.802410E-01  54.47021 3.487653E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 1064.328 2.399669E-03 3.986997E-03  253.2138 3.194886E-02 3.104662E-02  81.60924 1.250868E-01 1.350518E-01  30.48193 -3.221866E-02 3.448865E-01  12.29439 -6.172284E-01 4.628571E-01  5.037722 -4.525936E-01 2.110426E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 41.56291 -3.454216E-03 -6.722497E-03  13.67627 7.218428E-02 -2.806471E-02  5.844390 2.544820E-01 5.820028E-02  2.471609 -2.934534E-01 3.916988E-01  1.028308 -7.385455E-01 5.047823E-01  0.407250 -1.947157E-01 1.790290E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.571464 0.05892219 -0.1930100  0.605580 .2976055 0.0960562  0.098561 -1.147506 0.9817609         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.036459 1.000000E+00 1.0000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 18.41930 8.650816E-02  4.812661 3.826699E-01  1.446447 7.093772E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.400413 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Mn\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 56347.140 1.771580E-03  8460.9430 1.357081E-02  1927.3250 6.690605E-02  543.23430 2.318541E-01  173.99050 4.799046E-01  59.36005 3.495737E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 1165.412 2.388751E-03 3.977318E-03  277.3276 3.181708E-02 3.103112E-02  89.47278 1.254670E-01 1.351894E-01  33.48256 -2.955431E-02 3.457387E-01  13.54037 -6.175160E-01 4.629205E-01  5.557972 -4.544458E-01 2.090592E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 45.83532 -3.665856E-03 -6.887578E-03  15.18777 7.231971E-02 -2.846816E-02  6.500710 2.544486E-01 6.031832E-02  2.751583 -2.910380E-01 3.938961E-01  1.145404 -7.359860E-01 5.013769E-01  0.453687 -1.997617E-01 1.792264E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.757999 0.05628572 -0.5035024  0.667022 0.2897491 0.2345011  0.105129 -1.140653 0.9141257         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.038418 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 20.94355 8.672702E-02  5.510486 3.841883E-01  1.665038 7.069071E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.461733 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Fe\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 61132.62 1.766111E-03  9179.342 1.353038E-02  2090.857 6.673128E-02  589.2479 2.314823E-01  188.7543 4.797058E-01  64.44629 3.501976E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 1259.980 2.438014E-03 4.028019E-03  299.8761 3.224048E-02 3.144647E-02  96.84917 1.265724E-01 1.368317E-01  36.31020 -3.139902E-02 3.487236E-01  14.72996 -6.207593E-01 4.617931E-01  6.066075 -4.502914E-01 2.043058E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 50.43485 -3.873256E-03 -7.017128E-03  16.83929 7.196598E-02 -2.877660E-02  7.192086 2.556591E-01 6.181383E-02  3.053420 -2.882837E-01 3.954946E-01  1.273643 -7.342822E-01 4.989059E-01  0.504091 -2.049353E-01 1.791251E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 1.950316 0.05694869 -0.4593796  0.736721 0.2882915 0.2852139  0.114177 -1.138159 0.9076485         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.041148 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 23.14994 8.876935E-02  6.122368 3.896319E-01  1.846601 7.014816E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.504361 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Co\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 66148.99 1.759787E-03  9933.077 1.348162E-02  2262.816 6.649342E-02  637.9154 2.307939E-01  204.4122 4.792919E-01  69.82538 3.514097E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 1378.841 2.376276E-03 3.971488E-03  328.2694 3.167450E-02 3.108174E-02  106.0946 1.262888E-01 1.357439E-01  39.83275 -2.584552E-02 3.476827E-01  16.18622 -6.183491E-01 4.626340E-01  6.667788 -4.567008E-01 2.051632E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 54.52355 -3.993004E-03 -7.290772E-03  18.29783 7.409663E-02 -2.926027E-02  7.867348 2.542000E-01 6.564150E-02  3.340534 -2.921657E-01 4.000652E-01  1.393756 -7.318703E-01 4.950236E-01  0.551326 -2.040784E-01 1.758240E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 2.151947 0.05379843 -0.2165496  0.811063 0.2759971 0.1240488  0.121017 -1.129692 0.9724064         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.043037 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 25.59306 9.004748E-02  6.800990 3.931703E-01  2.051647 6.976844E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.555671 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Ni\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 71396.35 1.753003E-03  10720.84 1.343122E-02  2442.129 6.627041E-02  688.4265 2.302508E-01  220.6153 4.790186E-01  75.39373 3.523444E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 1492.532 2.370714E-03 3.967554E-03  355.4013 3.160566E-02 3.109479E-02  114.9534 1.266335E-01 1.359517E-01  43.22043 -2.417037E-02 3.485136E-01  17.59710 -6.187775E-01 4.625498E-01  7.257765 -4.576770E-01 2.035186E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 59.35261 -4.162002E-03 -7.421452E-03  20.02181 7.425111E-02 -2.953410E-02  8.614561 2.541360E-01 6.731852E-02  3.660531 -2.903477E-01 4.016660E-01  1.528111 -7.302121E-01 4.926623E-01  0.604057 -2.076057E-01 1.756893E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 2.379276 0.05157888 -0.1887663  0.885839 0.2707611 0.1015199  0.128529 -1.124770 0.9790906         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.045195 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 28.19147 9.098881E-02  7.523584 3.958208E-01  2.271228 6.947154E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.611603 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Cu\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 76794.38 1.748161E-03  11530.70 1.339602E-02  2626.575 6.610885E-02  740.4903 2.298265E-01  237.3528 4.787675E-01  81.15818 3.530739E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 1610.814 2.364055E-03 3.963307E-03  383.6367 3.153635E-02 3.110223E-02  124.1733 1.269452E-01 1.361350E-01  46.74678 -2.262840E-02 3.492914E-01  19.06569 -6.192080E-01 4.624780E-01  7.871567 -4.585393E-01 2.020102E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 64.45732 -4.331075E-03 -7.523725E-03  21.85212 7.412307E-02 -2.975687E-02  9.405343 2.542108E-01 6.849654E-02  3.999168 -2.874843E-01 4.027141E-01  1.670297 -7.291436E-01 4.908490E-01  0.659627 -2.113951E-01 1.759268E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 2.600088 0.05027577 -0.1702911  0.963094 0.2650040 0.09310133  0.136161 -1.120155 0.9814336         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.047332 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 30.85341 9.199905E-02  8.264985 3.985021E-01  2.495332 6.917897E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.667658 1.000000E+00         </cml:matrix>     </contraction>   </contractions>    <contractions elementType=\"Zn\">     <dc:description>(22s,16p,4d)->[5s,4p,2d]</dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"6\" columns=\"2\" dataType=\"double\"> 82400.94 1.743329E-03  12372.55 1.335966E-02  2818.351 6.594365E-02  794.5717 2.294151E-01  254.7232 4.785453E-01  87.13880 3.537753E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 1732.569 2.361459E-03 3.963125E-03  412.7149 3.150177E-02 3.113411E-02  133.6780 1.272774E-01 1.363931E-01  50.38585 -2.145928E-02 3.501266E-01  20.58358 -6.197652E-01 4.623179E-01  8.505940 -4.590180E-01 2.004995E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"6\" columns=\"3\" dataType=\"double\"> 69.36492 -4.440098E-03 -7.689262E-03  23.62082 7.505253E-02 -2.997982E-02  10.18471 2.533111E-01 7.082411E-02  4.334082 -2.881897E-01 4.046141E-01  1.810918 -7.267052E-01 4.882325E-01  0.714841 -2.133439E-01 1.751970E-01         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"3\" columns=\"3\" dataType=\"double\"> 2.823842 0.04898543 -0.1586763  1.039543 0.2592793 0.08379327  0.143264 -1.115711 0.9840547         </cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"double\"> 0.049296 1.000000E+00 1.00000000         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"3\" columns=\"2\" dataType=\"double\"> 33.70764 9.262648E-02  9.061106 4.002980E-01  2.738383 6.896608E-01         </cml:matrix>     </contraction>     <contraction shell=\"D\">       <cml:matrix rows=\"1\" columns=\"2\" dataType=\"double\"> 0.730294 1.000000E+00         </cml:matrix>     </contraction>   </contractions>   </basisSet>  ";
        String newSet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <basisset xmlns=\"http://purl.oclc.org/NET/EMSL/BSE\" xmlns:cmcs=\"http://purl.oclc.org/NET/cmcs/schema/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cml=\"http://www.xml-cml.org/schema/cml2/core\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">   <conversion>false</conversion>   <basisSetType>orbital</basisSetType>   <dc:format>chemical/x-emsl-gaussian-basisset</dc:format>   <dc:title>6-31G</dc:title>   <harmonicType>spherical</harmonicType>   <contractionType>segmented</contractionType>   <referencesLink xlink:type=\"simple\" xlink:href=\"6-31G-BS-REF.xml\" />   <dc:description>adding for test</dc:description>   <contractions elementType=\"Be\">     <dc:description><![CDATA[(8s,3p) -> [3s,2p]]]></dc:description>     <contraction shell=\"S\">       <cml:matrix rows=\"5\" columns=\"2\" dataType=\"xs:double\">554.0100000 0.00540997 83.2631000 0.04025150 18.8635000 0.17685800 5.1778200 0.45255900 1.5560200 0.47029300</cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"2\" columns=\"3\" dataType=\"xs:double\">1.4417524910 -0.4774290 0.2011420 0.3018610597 1.2474500 0.8844830</cml:matrix>     </contraction>     <contraction shell=\"SP\">       <cml:matrix rows=\"1\" columns=\"3\" dataType=\"xs:double\">0.1009613875 1.0000000 1.0000000</cml:matrix>     </contraction>   </contractions> </basisset>  ";
        try {
            String result = BasisSetMerge.merge(origSet, newSet, new Vector());
            System.out.println(result);
        }
        catch (Exception e) {
            System.err.println("Exception occured while merging " + e);
            e.printStackTrace();
        }
    }

    public static String merge(String originalSet, String newSet, Vector conflictsStrs) throws JDOMException, IOException, Exception {
        SAXBuilder builder = new SAXBuilder();
        ByteArrayInputStream origStream = new ByteArrayInputStream(originalSet.getBytes());
        ByteArrayInputStream newStream = new ByteArrayInputStream(newSet.getBytes());
        Document origDoc = builder.build(origStream);
        Document newDoc = builder.build(newStream);
        Element newRoot = newDoc.getRootElement();
        Element origRoot = origDoc.getRootElement();
        if (newRoot != null && origRoot != null) {
            String newName;
            String origName = origRoot.getName();
            if (!origName.equalsIgnoreCase(newName = newRoot.getName())) {
                throw new Exception("Cannot merge incompatible basis set types: " + origName + " with " + newName);
            }
            if (origName.equals("effectivePotentials")) {
                BasisSetMerge.mergePotentials(origDoc, newDoc, conflictsStrs);
            } else {
                BasisSetMerge.mergeContractions(origDoc, newDoc, conflictsStrs);
            }
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(origDoc);
    }

    protected static void mergeContractions(Document origDoc, Document newDoc, Vector conflictsStrs) throws Exception {
        String contractionsName = "contractions";
        String contractionName = "contraction";
        Element newRoot = newDoc.getRootElement();
        Element origRoot = origDoc.getRootElement();
        List origContractionsElements = origRoot.getChildren(contractionsName, bseNS);
        List newContractionsELements = newRoot.getChildren(contractionsName, bseNS);
        for (Element contractionsElement : newContractionsELements) {
            String elementType = contractionsElement.getAttributeValue("elementType");
            if (elementType == null) continue;
            List newcontractions = contractionsElement.getChildren(contractionName, bseNS);
            LinkedList<Object> newList = new LinkedList<Object>();
            Iterator iter = newcontractions.iterator();
            while (iter.hasNext()) {
                newList.add(((Element)iter.next()).clone());
            }
            Element origContractionsElement = null;
            Iterator origElementsIter = origContractionsElements.iterator();
            while (origElementsIter.hasNext() && origContractionsElement == null) {
                Element tempElement = (Element)origElementsIter.next();
                String tempElementType = tempElement.getAttributeValue("elementType");
                if (tempElementType == null || !tempElementType.equals(elementType)) continue;
                origContractionsElement = tempElement;
            }
            if (origContractionsElement == null) {
                origContractionsElement = new Element(contractionsName, bseNS);
                origContractionsElement.setAttribute("elementType", elementType);
                origRoot.addContent(origContractionsElement);
            } else {
                conflictsStrs.add(elementType);
            }
            origContractionsElement.removeContent();
            origContractionsElement.addContent(newList);
        }
        BasisSetMerge.sort(origRoot, contractionsName);
    }

    protected static void mergePotentials(Document origDoc, Document newDoc, Vector conflictsStrs) throws Exception {
        String potentialsName = "potentials";
        String potentialName = "potential";
        Element newRoot = newDoc.getRootElement();
        Element origRoot = origDoc.getRootElement();
        List origPotentialsElements = origRoot.getChildren(potentialsName, bseNS);
        List newPotentialsElements = newRoot.getChildren(potentialsName, bseNS);
        for (Element potentialsElement : newPotentialsElements) {
            String elementType = potentialsElement.getAttributeValue("elementType");
            String numElectrons = potentialsElement.getAttributeValue("numElectronsReplaced");
            if (elementType == null) continue;
            List newpotentials = potentialsElement.getChildren(potentialName, bseNS);
            LinkedList<Object> newList = new LinkedList<Object>();
            Iterator iter = newpotentials.iterator();
            while (iter.hasNext()) {
                newList.add(((Element)iter.next()).clone());
            }
            Element origPotentialsElement = null;
            Iterator origElementsIter = origPotentialsElements.iterator();
            while (origElementsIter.hasNext() && origPotentialsElement == null) {
                Element tempElement = (Element)origElementsIter.next();
                String tempElementType = tempElement.getAttributeValue("elementType");
                if (tempElementType == null || !tempElementType.equals(elementType)) continue;
                origPotentialsElement = tempElement;
            }
            if (origPotentialsElement == null) {
                origPotentialsElement = new Element("potentials", bseNS);
                origPotentialsElement.setAttribute("elementType", elementType);
                if (numElectrons != null) {
                    origPotentialsElement.setAttribute("numElectronsReplaced", numElectrons);
                }
                origRoot.addContent(origPotentialsElement);
            } else {
                conflictsStrs.add(elementType);
            }
            origPotentialsElement.removeContent();
            origPotentialsElement.addContent(newList);
        }
        BasisSetMerge.sort(origRoot, potentialsName);
    }

    protected static void sort(Element origRoot, String elementToSortName) throws Exception {
        LinkedList<Element> resultList = new LinkedList<Element>();
        LinkedList<Element> elementsToSort = new LinkedList<Element>();
        List elementsFromRoot = origRoot.removeContent();
        for (Object next : elementsFromRoot) {
            if (next instanceof Element) {
                Element nextEl = (Element)next;
                if (nextEl.getName().equals(elementToSortName)) {
                    elementsToSort.add(nextEl);
                    continue;
                }
                resultList.add(nextEl);
                continue;
            }
            resultList.add((Element)next);
        }
        try {
            Collections.sort(elementsToSort, mComparator);
            resultList.addAll(elementsToSort);
            origRoot.setContent(resultList);
        }
        catch (Exception e) {
            origRoot.setContent(elementsFromRoot);
            e.printStackTrace();
            throw e;
        }
    }
}

