      logical function tce_cholesky(rtdb,dim)
c
c $Id$
c
c Main routine for many-electron theory calculations.
c Some of the subroutines have been generated by
c operator/tensor contraction engines.
c
c Written by Jeff Hammond, January 2008.
c
      implicit none
#include "mafdecls.fh"
#include "tcgmsg.fh"
#include "global.fh"
#include "bas.fh"
#include "geom.fh"
#include "rtdb.fh"
#include "sym.fh"
#include "util.fh"
#include "msgids.fh"
#include "stdio.fh"
#include "sf.fh"
#include "inp.fh"
#include "errquit.fh"
#include "tce.fh"
#include "tce_main.fh"
c#include "tce_prop.fh"
#include "tce_ints.fh"
c#include "tce_amps.fh"
c#include "tce_diis.fh"
c
      integer rtdb
      integer dim
      logical nodezero
      logical dft_energy
      external dft_energy
      logical scf
      external scf
      double precision cpu,wall
      double precision ref     ! Ground state energy
      character*255 basisname  ! Basis set name
c
      nodezero=(ga_nodeid().eq.0)
      tce_cholesky = .false.
c
c     =========================
c     Ground-state HF/DFT first
c     =========================
c
      if (.not.rtdb_get(rtdb,'tce:reference',mt_int,1,reference)) then
        reference = 1
        if (.not.rtdb_put(rtdb,'tce:reference',mt_int,1,reference))
     1    call errquit('tce_energy: failed to write reference',0,
     2    RTDB_ERR)
      endif
      if (reference.eq.0) then
        if (.not.dft_energy(rtdb)) return
        if (.not.rtdb_get(rtdb,'dft:energy',mt_dbl,1,ref))
     1    call errquit('tce_energy: failed to get dft energy',0,
     2    RTDB_ERR)
      else if (reference.eq.1) then
        if (.not.scf(rtdb)) return
        if (.not.rtdb_get(rtdb,'scf:energy',mt_dbl,1,ref))
     1    call errquit('tce_energy: failed to get scf energy',0,
     2    RTDB_ERR)
      else
        call errquit('tce_energy: illegal reference',reference,
     1    UNKNOWN_ERR)
      endif
c
c     ===================
c     Print utility start
c     ===================
c
      call util_print_push
      call util_print_rtdb_load(rtdb,'tce')
c
c     ==========
c     Initialize
c     ==========
c
#ifdef DEBUG_PRINT
      print*,'before tce_init'
#endif
      call tce_init(rtdb)
#ifdef DEBUG_PRINT
      print*,'after tce_init'
#endif
c
c     ==============
c     Create a mutex
c     ==============
c
      if (.not.ga_create_mutexes(1))
     1  call errquit('tce_cholesky: GA problem',0,GA_ERR)
c
c     ======================
c     Test Cholesky routines
c     ======================
c
#ifdef DEBUG_PRINT
      print*,'before tce_ao2e_cholesky'
#endif
      if (dim.eq.0)
     &    call tce_ao2e_cholesky(rtdb,d_ao2e) 
      if (dim.eq.2)
     &    call tce_ao2e_cholesky_2d(rtdb,d_ao2e) 
      if (dim.eq.4) 
     &    call tce_ao2e_cholesky_4d(rtdb,d_ao2e) 
#ifdef DEBUG_PRINT
      print*,'after tce_ao2e_cholesky'
#endif
c
c     ===============
c     Destroy a mutex
c     ===============
c
      if (.not.ga_destroy_mutexes())
     1  call errquit('tce_cholesky: GA problem',1,GA_ERR)
c
c     =========
c     Terminate
c     =========
c
      tce_cholesky = .true.
      call tce_tidy(rtdb)
      call util_print_pop
      return
c
c     ======
c     Format
c     ======
c
 9020 format(1x,'Cpu & wall time / sec',2f15.1)
      end
