% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-expand.R
\name{replace_na.tbl_lazy}
\alias{replace_na.tbl_lazy}
\title{Replace NAs with specified values}
\usage{
\method{replace_na}{tbl_lazy}(data, replace = list(), ...)
}
\arguments{
\item{data}{A pair of lazy data frame backed by database queries.}

\item{replace}{A named list of values, with one value for each column that
has NA values to be replaced.}

\item{...}{Unused; included for compatibility with generic.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[dplyr:explain]{dplyr::show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is a method for the \code{\link[tidyr:replace_na]{tidyr::replace_na()}} generic.
}
\examples{
\dontshow{if (rlang::is_installed("tidyr", version = "1.0.0")) withAutoprint(\{ # examplesIf}
df <- memdb_frame(x = c(1, 2, NA), y = c("a", NA, "b"))
df \%>\% tidyr::replace_na(list(x = 0, y = "unknown"))
\dontshow{\}) # examplesIf}
}
