% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{components}
\alias{components}
\alias{[.mpoly}
\alias{LT}
\alias{LC}
\alias{LM}
\alias{multideg}
\alias{totaldeg}
\alias{monomials}
\alias{exponents}
\alias{coef.mpoly}
\alias{normalize_coefficients}
\alias{coef_lift}
\title{Polynomial components}
\usage{
\method{[}{mpoly}(x, ndx)

LT(x, varorder = vars(x), order = "lex")

LC(x, varorder = vars(x), order = "lex")

LM(x, varorder = vars(x), order = "lex")

multideg(x, varorder = vars(x), order = "lex")

totaldeg(x)

monomials(x, unit = FALSE)

exponents(x, reduced = FALSE)

\method{coef}{mpoly}(object, ...)

normalize_coefficients(p, norm = function(x) sqrt(sum(x^2)))

coef_lift(p)
}
\arguments{
\item{x}{an object of class mpoly}

\item{ndx}{a subsetting index}

\item{varorder}{the order of the variables}

\item{order}{a total order used to order the terms}

\item{unit}{for \code{\link[=monomials]{monomials()}}, should the monomials have coefficient 1?}

\item{reduced}{if TRUE, don't include zero degrees}

\item{object}{mpoly object to pass to \code{\link[=coef]{coef()}}}

\item{...}{In \code{\link[=coef]{coef()}}, additional arguments passed to \code{\link[=print.mpoly]{print.mpoly()}} for
the names of the resulting vector}

\item{p}{an object of class mpoly or mpolyList}

\item{norm}{a norm (function) to normalize the coefficients of a polynomial,
defaults to the Euclidean norm}
}
\value{
An object of class mpoly or mpolyList, depending on the context
}
\description{
Compute quantities/expressions related to a multivariate polynomial.
}
\examples{
(p <- mp("x y^2 + x (x+1) (x+2) x z + 3 x^10"))
p[2]
p[-2]
p[2:3]

LT(p)
LC(p)
LM(p)

multideg(p)
totaldeg(p)
monomials(p)
monomials(p, unit = TRUE)
coef(p)

p[1:2]
coef_lift(p[1:2])

exponents(p)
exponents(p, reduce = TRUE)
lapply(exponents(p), is.integer)

homogeneous_components(p)

(p <- mp("(x + y)^2"))
normalize_coefficients(p)
norm <- function(v) sqrt(sum(v^2))
norm(coef( normalize_coefficients(p) ))

abs_norm <- function(x) sum(abs(x))
normalize_coefficients(p, norm = abs_norm)

p <- mp(c("x", "2 y"))
normalize_coefficients(p)

# normalize_coefficients on the zero polynomial returns the zero polynomial
normalize_coefficients(mp("0"))


}
