A `break` statement without a label appeared inside a labeled block.

Erroneous code example:

```compile_fail,E0695
loop {
    'a: {
        break;
    }
}
```

Make sure to always label the `break`:

```
'l: loop {
    'a: {
        break 'l;
    }
}
```

Or if you want to `break` the labeled block:

```
loop {
    'a: {
        break 'a;
    }
    break;
}
```
