# 2024-10-29 Triage Log

This week saw a lot of activity both on the regressions and improvements side. There was one large
regression, which was immediately reverted. Overall, the week ended up being positive, thanks to
a rollup PR that caused a tiny improvement to almost all benchmarks.

Triage done by **@kobzol**.
Revision range: [3e33bda0..c8a8c820](https://perf.rust-lang.org/?start=3e33bda0326586a6e1e34d0f5c060ca6d116e6a4&end=c8a8c82035439cb2404b8f24ca0bc18209d534ca&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.2%, 2.7%]   | 15    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.1%, 1.6%]   | 22    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.5%, -0.2%] | 153   |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.9%, -0.1%] | 80    |
| All ❌✅ (primary)                 | -0.5% | [-1.5%, 2.7%]  | 168   |


6 Regressions, 6 Improvements, 4 Mixed; 6 of them in rollups
58 artifact comparisons made in total

#### Regressions

Revise arm platform notes regarding soft float [#130987](https://github.com/rust-lang/rust/pull/130987) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3ec4308f6cb4bba3140d736d9ebd53b234fa7df8&end=edbd9398dcc0e3b6ffe0dd0cd4578d37d1d36974&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.9% | [2.9%, 2.9%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.9% | [2.9%, 2.9%] | 1     |

- Noise, this PR only modified documentation.
- Marked as triaged.

Dont consider predicates that may hold as impossible in `is_impossible_associated_item` [#131840](https://github.com/rust-lang/rust/pull/131840) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4392847410ddd67f6734dd9845f9742ff9e85c83&end=814df6e50eaf89b90793e7d9618bb60f1f18377a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.2%, 2.3%] | 9     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.2%, 0.2%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.2%, 2.3%] | 9     |

- The largest regression was just noise, the rest was small enough and was deemed to be acceptable.
- Marked as triaged.

nightly feature tracking: get rid of the per-feature bool fields [#132027](https://github.com/rust-lang/rust/pull/132027) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ffd978b7bf4ccdc74fe6c1b048d253eb3f3aa341&end=be01dabfefd2daa4574b974f571c7852085d60cb&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2% | [1.1%, 1.2%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.1%, 1.1%] | 34    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.2% | [1.1%, 1.2%] | 4     |

- The small regressions were only on tiny benchmarks and stress tests, which was deemed to be acceptable.

Rollup of 10 pull requests [#132094](https://github.com/rust-lang/rust/pull/132094) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b8bb2968ce1e44d01520c9d59ee6299ed66df3f9&end=55b7f8e800a6a43657a8582450323d546297c950&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.1%, 0.2%] | 4     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.1%, 0.2%] | 4     |

- The tiny regressions were reverted in a follow-up merge.
- Marked as triaged.

Emit future-incompatibility lint when calling/declaring functions with vectors that require missing target feature [#127731](https://github.com/rust-lang/rust/pull/127731) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=45089ec19ebebec88bace6ec237244ff0eaa7ad3&end=6faf0bd3e561f1a0c81f3eafe0ce0e688385d70e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 5.0%  | [0.3%, 16.9%]  | 77    |
| Regressions ❌ <br /> (secondary)  | 4.7%  | [0.1%, 29.4%]  | 30    |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 4.9%  | [-0.1%, 16.9%] | 78    |

- This was a large regression that was immediately reverted in https://github.com/rust-lang/rust/pull/132152.
- Investigation into how to land this change without such large regressions is happening in https://github.com/rust-lang/rust/pull/132173
- Marked as triaged.

bump stdarch [#132145](https://github.com/rust-lang/rust/pull/132145) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9f57edf2e261ade3c926d69459162057f15164d6&end=3f1be1ec7ec3d8e80beb381ee82164a0aa3ca777&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9% | [0.9%, 0.9%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.9% | [0.9%, 0.9%] | 1     |

- One tiny regression caused by a dependency upgrade, no need to investigate further.
- Marked as triaged.

#### Improvements

(ci) Update macOS Xcode to 15 [#131570](https://github.com/rust-lang/rust/pull/131570) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=31e102c509192189be841954f38962eb3cd9e2e2&end=4392847410ddd67f6734dd9845f9742ff9e85c83&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -3.6% | [-3.6%, -3.6%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -3.6% | [-3.6%, -3.6%] | 1     |


better default capacity for str::replace [#131929](https://github.com/rust-lang/rust/pull/131929) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8bf64f106ac0cd1f2b9c6fd27965dd2dc4b862dd&end=b13176595d8a9fd27334747080764a53a18f4c24&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 3     |


rustdoc: hash assets at rustdoc build time [#131951](https://github.com/rust-lang/rust/pull/131951) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=55b7f8e800a6a43657a8582450323d546297c950&end=8aca4bab080b2c81065645fc070acca7a060f8a3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.1%] | 17    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.1%] | 6     |


Revert #127731 "Emit error when calling/declaring functions with unavailable …" [#132152](https://github.com/rust-lang/rust/pull/132152) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a06b7cbe21967a86050fa92dab843c8afda1c28e&end=ae4c6b66402cdbda8daa626216efd94e2dbe94b2&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]    | 1     |
| Improvements ✅ <br /> (primary)   | -4.7% | [-14.4%, -0.3%] | 75    |
| Improvements ✅ <br /> (secondary) | -4.5% | [-22.7%, -0.2%] | 27    |
| All ❌✅ (primary)                 | -4.7% | [-14.4%, -0.3%] | 75    |

- Revert of the previously mentioned [#127731](https://github.com/rust-lang/rust/pull/127731).

Rollup of 3 pull requests [#132171](https://github.com/rust-lang/rust/pull/132171) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ae4c6b66402cdbda8daa626216efd94e2dbe94b2&end=80d0d927d5069b67cc08c0c65b48e7b6e0cdeeb5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 16    |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 2     |

- The small wins probably come from [#132168](https://github.com/rust-lang/rust/pull/132168).

Rollup of 9 pull requests [#132277](https://github.com/rust-lang/rust/pull/132277) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a9d17627d241645a54c1134a20f1596127fedb60&end=2df8dbb1b37168c59eca2884502a1b79892858a9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.7%, -0.1%] | 186   |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.7%, -0.1%] | 92    |
| All ❌✅ (primary)                 | -0.5% | [-1.7%, -0.1%] | 186   |

- The large amount of small wins might have been caused by [#130259](https://github.com/rust-lang/rust/pull/130259).

#### Mixed

Rollup of 5 pull requests [#132053](https://github.com/rust-lang/rust/pull/132053) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e1f306899514ea80abc1d1c9f6a57762afb304a3&end=9abfcb49002b82f46ad66ceb0b26cee8be2dc658&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.3%, 1.8%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | 1.0%  | [0.3%, 1.8%]   | 2     |

- Large number of small-ish regressions that were just under the statistical threshold.
- Might have been caused by LLVM doing more work because of [#132031](https://github.com/rust-lang/rust/pull/132031).
- Not marking as triaged yet, investigation ongoing.

Represent trait constness as a distinct predicate [#131985](https://github.com/rust-lang/rust/pull/131985) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f61306d47bc98af8bb9d15f1adf6086785590a8c&end=1d4a7670d4f37bfbae2d89ec3ec07cd40dbc5a5d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 1.2%]   | 16    |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.1%, 1.5%]   | 22    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.1%] | 44    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.1%] | 13    |
| All ❌✅ (primary)                 | -0.1% | [-0.5%, 1.2%]  | 60    |

- This was a large internal refactoring that had mostly positive or neutral effects on performance,
  although it did cause regressions in `doc` builds on several benchmarks.
- It was deemed acceptable during review.
- Marked as triaged.

Rollup of 4 pull requests [#132116](https://github.com/rust-lang/rust/pull/132116) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1d4a7670d4f37bfbae2d89ec3ec07cd40dbc5a5d&end=a93c1718c80b9f100056c8eec3fc37fbd6424134&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 1.8%]   | 49    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.1%, 1.3%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.8%, -0.1%] | 3     |
| All ❌✅ (primary)                 | 0.3%  | [-0.3%, 1.8%]  | 50    |

- The regression was caused by [#131983](https://github.com/rust-lang/rust/pull/131983), which
  stabilized a new behavior change that will appear in Edition 2024.
- Not marking as triaged yet, there might be a way to claw some of the regressions back.

Rollup of 12 pull requests [#132317](https://github.com/rust-lang/rust/pull/132317) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c8a8c82035439cb2404b8f24ca0bc18209d534ca&end=2dece5bb62f234f5622a08289c5a3d1555cd7843&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.4%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.4%, -0.1%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -0.0% | [-0.4%, 0.4%]  | 10    |

- Performance results were a wash.
- Marked as triaged.
