/*
 * Copyright (C) 2022 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "CompositeOperation.h"

#include "CSSPrimitiveValue.h"
#include "CSSValue.h"
#include "CSSValueKeywords.h"
#include <wtf/text/TextStream.h>

namespace WebCore {

std::optional<CompositeOperation> toCompositeOperation(const CSSValue& value)
{
    if (!is<CSSPrimitiveValue>(value))
        return std::nullopt;

    switch (value.valueID()) {
    case CSSValueAdd:
        return CompositeOperation::Add;
    case CSSValueAccumulate:
        return CompositeOperation::Accumulate;
    case CSSValueReplace:
        return CompositeOperation::Replace;
    default:
        return std::nullopt;
    }
}

TextStream& operator<<(TextStream& ts, CompositeOperation operation)
{
    switch (operation) {
    case CompositeOperation::Add: ts << "add"_s; break;
    case CompositeOperation::Accumulate: ts << "accumulate"_s; break;
    case CompositeOperation::Replace: ts << "replace"_s; break;
    }
    return ts;
}

} // namespace WebCore
